<?php
// This script assumes it is included in admin_dashboard.php, 
// so the $conn object (database connection) and $_SESSION data are already available.

$message = '';
$user_id = $_SESSION['user_id'] ?? 1; // Default to ID 1 if session ID is missing

// 1. Handle the form submission for creating a new client
if ($_SERVER["REQUEST_METHOD"] == "POST" && isset($_POST['create_client'])) {
    
    // Sanitize and prepare core client data
    $company_name = $conn->real_escape_string($_POST['company_name']);
    $address = $conn->real_escape_string($_POST['address']);
    $company_email = $conn->real_escape_string($_POST['company_email']);
    $website = $conn->real_escape_string($_POST['website']);
    
    // Sanitize and prepare representative data
    $rep_name = $conn->real_escape_string($_POST['rep_name']);
    $rep_designation = $conn->real_escape_string($_POST['rep_designation']);
    $rep_email = $conn->real_escape_string($_POST['rep_email']);
    $rep_phone_number = $conn->real_escape_string($_POST['rep_phone_number']);
    
    // Basic validation
    if (empty($company_name) || empty($rep_name)) {
        $message = "<p style='color:red;'>ERROR: Company Name and Representative Name are required fields.</p>";
    } else {
        
        // Prepare the SQL INSERT statement for the clients table
        $sql = "INSERT INTO clients (company_name, address, company_email, website, 
                                     rep_name, rep_designation, rep_email, rep_phone_number) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?)";
        
        $stmt = $conn->prepare($sql);
        
        if ($stmt === false) {
             $message = "<p style='color:red;'>Database prepare error: " . $conn->error . "</p>";
        } else {
            // Bind parameters (8 strings: ssssssss)
            $stmt->bind_param("ssssssss", 
                $company_name, $address, $company_email, $website, 
                $rep_name, $rep_designation, $rep_email, $rep_phone_number
            );
        
            if ($stmt->execute()) {
                $message = "<p style='color:green;'>Client <b>{$company_name}</b> successfully created and added to the portfolio.</p>";
            } else {
                $message = "<p style='color:red;'>Database insert failed: " . $stmt->error . "</p>";
            }
            $stmt->close();
        }
    }
}
?>

<div class="form-card">
    <h3>1. Create New Client Portfolio Entry</h3>
    <p>Use this form to add a new client and their core portfolio details.</p>
    
    <?php echo $message; // Display success or error messages ?>

    <form action="admin_dashboard.php?page=manage_clients" method="post">
        
        <!-- --- Client Details Section --- -->
        <h4>Company Information</h4>
        
        <label for="company_name">Company Name (Required):</label>
        <input type="text" name="company_name" id="company_name" required>
        
        <label for="address">Address:</label>
        <input type="text" name="address" id="address">
        
        <label for="company_email">Company Email:</label>
        <input type="email" name="company_email" id="company_email">
        
        <label for="website">Website:</label>
        <input type="text" name="website" id="website">

        <!-- --- Representative Details Section --- -->
        <h4 style="margin-top: 30px;">Key Representative Information</h4>
        
        <label for="rep_name">Representative's Name (Required):</label>
        <input type="text" name="rep_name" id="rep_name" required>
        
        <label for="rep_designation">Designation:</label>
        <input type="text" name="rep_designation" id="rep_designation">
        
        <label for="rep_email">Representative Email:</label>
        <input type="email" name="rep_email" id="rep_email">
        
        <label for="rep_phone_number">Representative Phone Number:</label>
        <input type="text" name="rep_phone_number" id="rep_phone_number">
        
        <button type="submit" name="create_client">Create Client Portfolio</button>
    </form>
</div>
